/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.AlignmentDialog;

import java.beans.PropertyVetoException;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.dialogs.AlignmentDialog;
import net.nooj4nlp.gui.main.Launcher;

public class AlignmentController {
    private int nbOfNodesAligned;
    private GrammarEditorShellController grammarController;
    private AlignmentDialog dialog;

    public AlignmentController(AlignmentDialog dialog, GrammarEditorShellController grammarController) {
        this.grammarController = grammarController;
        this.dialog = dialog;
    }

    public void close() {
        this.grammarController.alignmentDialog = null;
        this.dialog.dispose();
    }

    public void bottomAlign() {
        int iNode;
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int lowest = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            int y;
            int line0;
            if (!grf.selected.get(iNode).booleanValue() || lowest >= (line0 = (y = grf.posY.get(iNode).intValue()) + grf.hei.get(iNode))) continue;
            lowest = line0;
        }
        this.nbOfNodesAligned = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            ++this.nbOfNodesAligned;
            grf.posY.set(iNode, lowest - grf.hei.get(iNode));
        }
        this.grammarController.modify("bottom-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void topAlign() {
        int iNode;
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int top = 999999999;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            int y;
            int line0;
            if (!grf.selected.get(iNode).booleanValue() || top <= (line0 = (y = grf.posY.get(iNode).intValue()) - grf.hei.get(iNode))) continue;
            top = line0;
        }
        this.nbOfNodesAligned = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            ++this.nbOfNodesAligned;
            grf.posY.set(iNode, top + grf.hei.get(iNode));
        }
        this.grammarController.modify("top-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void centerHorizontalAlign() {
        int iNode;
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int average = 0;
        int nbSelected = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            int y = grf.posY.get(iNode);
            average += y;
            ++nbSelected;
        }
        if (nbSelected < 2) {
            return;
        }
        average /= nbSelected;
        this.nbOfNodesAligned = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            ++this.nbOfNodesAligned;
            grf.posY.set(iNode, average);
        }
        this.grammarController.modify("horizontal-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void leftAlign() {
        int iNode;
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int lowest = 999999999;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            int x;
            if (!grf.selected.get(iNode).booleanValue() || lowest <= (x = grf.posX.get(iNode).intValue())) continue;
            lowest = x;
        }
        this.nbOfNodesAligned = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            ++this.nbOfNodesAligned;
            grf.posX.set(iNode, lowest);
        }
        this.grammarController.modify("left-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void rightAlign() {
        int iNode;
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int rightest = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            int x;
            int right;
            if (!grf.selected.get(iNode).booleanValue() || rightest >= (right = (x = grf.posX.get(iNode).intValue()) + grf.wid.get(iNode))) continue;
            rightest = right;
        }
        this.nbOfNodesAligned = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            ++this.nbOfNodesAligned;
            grf.posX.set(iNode, rightest - grf.wid.get(iNode));
        }
        this.grammarController.modify("right-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void centerVerticalAlign() {
        int iNode;
        if (this.grammarController == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        int average = 0;
        int nbSelected = 0;
        this.nbOfNodesAligned = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            ++this.nbOfNodesAligned;
            ++nbSelected;
            int x = grf.posX.get(iNode);
            int center = x + (int)((float)grf.wid.get(iNode).intValue() / 2.0f);
            average += center;
        }
        if (nbSelected < 2) {
            return;
        }
        average /= nbSelected;
        this.nbOfNodesAligned = 0;
        for (iNode = 0; iNode < grf.selected.size(); ++iNode) {
            if (!grf.selected.get(iNode).booleanValue()) continue;
            ++this.nbOfNodesAligned;
            grf.posX.set(iNode, average - (int)((float)grf.wid.get(iNode).intValue() / 2.0f));
        }
        this.grammarController.modify("vertical-align " + this.nbOfNodesAligned + " nodes", false, false);
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }

    public void useGrid() {
        if (this.grammarController == null) {
            return;
        }
        Grammar grm = this.grammarController.grammar;
        if (grm == null) {
            return;
        }
        Graph grf = this.grammarController.grf;
        if (grf == null) {
            return;
        }
        grm.dispGrid = this.dialog.getCbUseGrid().isSelected();
        for (int iNode = 0; iNode < grf.posX.size(); ++iNode) {
            grf.posX.set(iNode, grf.posX.get(iNode) / 20 * 20);
            grf.posY.set(iNode, grf.posY.get(iNode) / 20 * 20);
        }
        if (grm.dispGrid) {
            this.grammarController.modify("snap to grid", false, false);
        }
        this.grammarController.editor.repaint();
        try {
            this.dialog.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
    }
}

